/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.BaseRotatedPillarBlock;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.worlds.together.tag.v3.MineableTags;
import org.betterx.worlds.together.tag.v3.TagManager;

public abstract class BaseStripableLogBlock
extends BaseRotatedPillarBlock {
    private final Block striped;

    protected BaseStripableLogBlock(Block striped, BlockBehaviour.Properties settings) {
        super(settings);
        this.striped = striped;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (TagManager.isToolWithMineableTag(player.m_21205_(), MineableTags.AXE)) {
            world.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                world.m_7731_(pos, (BlockState)this.striped.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))), 11);
                if (!player.m_7500_()) {
                    player.m_21205_().m_220157_(1, world.f_46441_, (ServerPlayer)player);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static class Wood
    extends BaseStripableLogBlock
    implements BehaviourWood,
    TagProvider {
        private final boolean flammable;

        public Wood(MapColor color, Block striped, boolean flammable) {
            super(striped, (flammable ? BlockBehaviour.Properties.m_60926_((BlockBehaviour)striped).m_278183_() : BlockBehaviour.Properties.m_60926_((BlockBehaviour)striped)).m_284180_(color));
            this.flammable = flammable;
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            blockTags.add((TagKey<Block>)BlockTags.f_13106_);
            itemTags.add((TagKey<Item>)ItemTags.f_13182_);
            if (this.flammable) {
                blockTags.add((TagKey<Block>)BlockTags.f_13105_);
                itemTags.add((TagKey<Item>)ItemTags.f_13181_);
            }
        }
    }
}

